Imports System.Data.OleDb

Public Class CodeDatabase
  Inherits System.Web.UI.Page
  Protected WithEvents Image2 As System.Web.UI.WebControls.Image
  Protected WithEvents Image3 As System.Web.UI.WebControls.Image
  Protected WithEvents Button1 As System.Web.UI.WebControls.Button
  Protected WithEvents DropDownList1 As System.Web.UI.WebControls.DropDownList
  Protected WithEvents TextBox1 As System.Web.UI.WebControls.TextBox
  Protected WithEvents Label3 As System.Web.UI.WebControls.Label
  Protected WithEvents Label2 As System.Web.UI.WebControls.Label
  Protected WithEvents Label1 As System.Web.UI.WebControls.Label
  Protected WithEvents Image1 As System.Web.UI.WebControls.Image

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
    'CODEGEN: This method call is required by the Web Form Designer
    'Do not modify it using the code editor.
    InitializeComponent()

    CreateConnection()
    Try
      InitializeFilter()
    Finally
      CloseConnection()
    End Try

  End Sub

#End Region

  Private Function GetDataSource() As String
    Return "Data Source=c:\inetpub\wwwroot\CodeDatabase\data\CodeDatabase.mdb;"
    'Return "Data Source=c:\temp\CodeDatabase.mdb;"
  End Function

  Private Function GetProvider() As String
    Return "Provider=Microsoft.Jet.OLEDB.4.0;"
  End Function

  Private Function GetConnectionString() As String
    Return GetProvider() & GetDataSource()
  End Function

  Private Function GetConnection() As OleDbConnection
    Return New OleDbConnection(GetConnectionString())
  End Function

  Private Sub InitializeFilter()
    ' Assumes connection is opened by caller
    Dim Command As New OleDbCommand( _
      "SELECT [Language], ID FROM [Language]", Connection)

    OpenConnection()

    Dim Reader As OleDbDataReader = _
      Command.ExecuteReader()

    DropDownList1.Items.Add("All")

    Try
      While (Reader.Read())
        DropDownList1.Items.Add( _
          Reader.GetString(0).ToString())
      End While
    Finally
      Reader.Close()
    End Try
  End Sub

  Private Connection As OleDbConnection

  Private Sub CreateConnection()
    Connection = GetConnection()
  End Sub

  Private Sub OpenConnection()
    Connection.Open()
  End Sub

  Private Sub CloseConnection()
    Connection.Close()
  End Sub

  Private Function GetDescriptionClause() As String
    Return String.Format("Source.Description LIKE '*{0}*'", _
        TextBox1.Text)
  End Function

  Private ReadOnly Property Language() As String
    Get
      If (DropDownList1.SelectedItem.Text = "All") Then
        Return "LIKE '*'"
      Else
        Return "='" & DropDownList1.SelectedItem.Text & "'"
      End If
    End Get
  End Property

  Private Function GetLanguageClause() As String
    Return String.Format("[Language].[Language] {0}", Language)
  End Function

  Private Function GetQuery() As String
    Const SQL = "SELECT Source.ID, [Name], Source.Description, Submitted " & _
      "FROM Source, [Language] " & _
      "WHERE Source.Language_Id = [Language].ID AND {0} AND {1}"
    Return String.Format(SQL, GetLanguageClause, GetDescriptionClause)
  End Function

  Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

    Dim Command As New OleDbCommand(GetQuery(), Connection)

    OpenConnection()
    Try

      Dim Reader As OleDbDataReader = Command.ExecuteReader()

      While (Reader.Read)
        Response.Write(Reader.GetValue(0).ToString() & " " & _
          Reader.GetValue(1).ToString() & "<br>")
      End While

    Finally
      Connection.Close()
    End Try

  End Sub

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    Response.Write("Foo")
  End Sub
End Class
